-- StepMania 5 default theme | script ring 03 | Gameplay.lua
-- someone thought it'd be a good idea to put theme preferences into the fallback
-- when they should've been in default instead. there is no emoticon for how i feel
-- at this moment right now -freem

-- for example, not every theme wants to worry about custom receptor positions.
local tNotePositions = {
	-- StepMania 3.9/4.0
	Normal = { -144, 144, },
	-- ITG
	Lower = { -125, 145, }
}

function GetTapPosition( sType )
	bCategory = (sType == 'Standard') and 1 or 2
	-- true: Normal
	-- false: Lower
	bPreference = ThemePrefs.Get("NotePosition") and "Normal" or "Lower"
	tNotePos = tNotePositions[bPreference]
	return tNotePos[bCategory]
end

-- combo under field is another thing that doesn't always need to be custom
function ComboUnderField()
	return ThemePrefs.Get("ComboUnderField")
end

local function CurGameName()
	return GAMESTATE:GetCurrentGame():GetName()
end

function GameCompatibleModes()
	local Modes = {
		dance = "Single,Double,Solo,Versus",
		pump = "Single,Double,Versus",
		techno = "TechnoS8,TechnoD8",
	}
	return Modes[CurGameName()]
end

function ScreenSelectStylePositions(count)
	local poses= {}
	local columns= 1
	local choice_height= 68
	local column_x= {_screen.cx, _screen.cx + 160}
	if count > 4 then
		column_x[1]= _screen.cx - 160
		columns= 2
	end
	if count > 8 then
		column_x[1]= _screen.cx - 240
		column_x[2]= _screen.cx
		column_x[3]= _screen.cx + 240
		columns= 3
	end
	local num_per_column= {math.ceil(count/columns), math.floor(count/columns)}
	if count > 8 then
		if count % 3 == 0 then
			num_per_column[3]= count/columns
		elseif count % 3 == 1 then
			num_per_column[3]= num_per_column[2]
		else
			num_per_column[3]= num_per_column[1]
		end
	end
	for c= 1, columns do
		local start_y= _screen.cy - (choice_height * ((num_per_column[c] / 2)+.5))
		for i= 1, num_per_column[c] do
			poses[#poses+1]= {column_x[c], start_y + (choice_height * i)}
		end
	end
	return poses
end